﻿using RedmineLineNotify.lib;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Threading;
using System.Windows.Controls;
using System.Windows.Shapes;
using System.Reflection;

namespace RedmineLineNotify
{
    public partial class frmMain : Form
    {
        private List<List<string>> Settings = new List<List<string>>();
        DataTable dtTimeSelect = new DataTable();
        DataTable dtIssueSelect = new DataTable();
        DataTable dtUserSelect = new DataTable();
        DataTable dtUserSelectAll = new DataTable();
        DataTable dtHolidaySelect = new DataTable();
        DataTable dtHolidaySelectYear = new DataTable();
        string strUserName = string.Empty;
        string strUserNameissues = string.Empty;
        string strStartDate = string.Empty;
        string strStartDateissues = string.Empty;
        string strID = string.Empty;
        string strDate = string.Empty;
        string strDueDate = string.Empty;
        string strHours = string.Empty;
        string strIDAll = string.Empty;
        string strIDAllissues = string.Empty;
        string strMSG = string.Empty;
        string strMSGissues = string.Empty;
        string strFirstDate = string.Empty;
        string strLastDate = string.Empty;
        string strCurrentDate = string.Empty;
        string strCurrentTime = string.Empty;
        string strBeforeDate = string.Empty;
        string isProcess = string.Empty;
        string isProcess_DueDate = string.Empty;
        Int32 intYearShow = 2023;

        private string PartFile_isProcess = System.IO.Directory.GetCurrentDirectory() + "\\isProcess.ini";

        private string PartFile_isProcess_DueDate = System.IO.Directory.GetCurrentDirectory() + "\\isProcessDueDate.ini";
        public frmMain()
        {
            InitializeComponent();
        }


        private Line_Notify line_Notify;
        /// <summary>
        /// 
        /// </summary>

        public string RtnDbCon()
        {
            return "Data Source=" + this.Settings[0][0] + ";Initial Catalog=" + this.Settings[0][1] + ";User Id=sa;Password=" + this.Settings[0][2] + ";";

        }

        private void frmMain_Load(object sender, EventArgs e)
        {
            Version version = Assembly.GetEntryAssembly().GetName().Version;

            this.Text = "Redmine Line Notify V." + version;

            line_Notify = new Line_Notify();

            List<string> tmp = null;
            Settings = new List<List<string>>();
            tmp = null;
            using (var csv = new CsvReader(System.IO.Directory.GetCurrentDirectory() + "\\Settings.csv"))
            {
                while ((tmp = csv.ReadRow()) != null)
                {
                    Settings.Add(tmp);

                }

            }//using end

            if (!File.Exists(PartFile_isProcess))
            {
                using (StreamWriter sw = File.CreateText(PartFile_isProcess))
                {
                    sw.Write("true");
                }
            }

            if (!File.Exists(PartFile_isProcess_DueDate))
            {
                using (StreamWriter sw = File.CreateText(PartFile_isProcess_DueDate))
                {
                    sw.Write("true");
                }
            }

            dtpHoliday.Format = DateTimePickerFormat.Short;

            isProcess = File.ReadAllText(PartFile_isProcess);

            isProcess_DueDate = File.ReadAllText(PartFile_isProcess_DueDate);

            lblDateTime.Text = DateTime.Now.ToString("MM/dd/yyyy HH:mm:ss");

            timer1.Enabled = true;

            intYearShow = DateTime.Now.Year;

            calendarShow(intYearShow, "");

        }

        private void process(string firstDate, string lastDate)
        {
            strFirstDate = firstDate;
            strLastDate = lastDate;
            List<string> dateHoursKeep = new List<string>();
            List<string> dateKeep = new List<string>();
            List<string> dateHolidayKeep = new List<string>();
            Double totalDay = 0;
            Int32 intTotalDay = 0;
            string strCheckDate = string.Empty;

            clsUtil_MSSQL.GetDataFromHolidayAll(RtnDbCon(), "date_holiday", ref dtHolidaySelect);
            if (dtHolidaySelect != null)
            {
                if (dtHolidaySelect.Rows.Count > 0)
                {
                    dateHolidayKeep.Clear();
                    for (int i = 0; i < dtHolidaySelect.Rows.Count; i++)
                    {
                        dateHolidayKeep.Add(Convert.ToDateTime(dtHolidaySelect.Rows[i][1].ToString()).Date.ToString("yyyy-MM-dd"));
                    }
                }

            }

            //Select User
            clsUtil_MSSQL.GetDataFromTBUserSelectAll(RtnDbCon(), "users", ref dtUserSelectAll);
            if (dtUserSelectAll != null)
            {
                if (dtUserSelectAll.Rows.Count > 0)
                {
                    for (int i = 0; i < dtUserSelectAll.Rows.Count; i++)
                    {
                        strIDAll = dtUserSelectAll.Rows[i][0].ToString();
                        strUserName = dtUserSelectAll.Rows[i][1].ToString();
                        if (dtUserSelectAll.Rows[i][2] != null)
                        {
                            strStartDate = Convert.ToDateTime(dtUserSelectAll.Rows[i][2].ToString()).ToString("yyyy-MM-dd");
                            strFirstDate = strStartDate;
                        }
                        else
                        {
                            strFirstDate = "2023-10-30";
                        }


                        //Select User Time
                        clsUtil_MSSQL.GetDataFromTBTimeSelect(RtnDbCon(), "[time_entries]", ref dtTimeSelect, strFirstDate, strLastDate, strIDAll);
                        if (dtTimeSelect != null)
                        {
                            if (dtTimeSelect.Rows.Count > 0)
                            {
                                dateHoursKeep.Clear();
                                dateKeep.Clear();

                                for (int j = 0; j < dtTimeSelect.Rows.Count; j++)
                                {
                                    strID = dtTimeSelect.Rows[j][0].ToString();
                                    strDate = Convert.ToDateTime(dtTimeSelect.Rows[j][2].ToString()).Date.ToString("yyyy-MM-dd");
                                    strHours = dtTimeSelect.Rows[j][1].ToString();

                                    dateHoursKeep.Add(strDate);
                                    dateHoursKeep.Add(strHours);
                                    dateKeep.Add(strDate);
                                }

                                totalDay = (Convert.ToDateTime(strLastDate) - Convert.ToDateTime(strFirstDate)).TotalDays;
                                intTotalDay = Convert.ToInt32(totalDay);
                                strCheckDate = strFirstDate; // "2023-10-30";
                                strMSG = "";

                                for (int k = 0; k <= intTotalDay; k++)
                                {
                                    if (!dateHolidayKeep.Contains(strCheckDate))
                                    {

                                        if (!dateKeep.Contains(strCheckDate))
                                        {
                                            if (strMSG == "")
                                            {
                                                strMSG = "\r\n" + strCheckDate + " " + strUserName + " 0/8";
                                            }
                                            else
                                            {
                                                strMSG = strMSG + "\r\n" + strCheckDate + " " + strUserName + " 0/8";
                                            }

                                        }
                                        else
                                        {
                                            foreach (var item in dateHoursKeep)
                                            {
                                                if (item == strCheckDate)
                                                {
                                                    int l = dateHoursKeep.IndexOf(item);
                                                    strHours = dateHoursKeep[l + 1];
                                                    break;
                                                }
                                            }
                                            if (Convert.ToDouble(strHours) < 8)
                                            {
                                                if (strMSG == "")
                                                {
                                                    strMSG = "\r\n" + strCheckDate + " " + strUserName + " " + strHours + "/8";
                                                }
                                                else
                                                {
                                                    strMSG = strMSG + "\r\n" + strCheckDate + " " + strUserName + " " + strHours + "/8";
                                                }
                                            }
                                        }

                                    }
                                    strCheckDate = Convert.ToDateTime(strCheckDate).Date.AddDays(1).ToString("yyyy-MM-dd");
                                }

                                sendLine(strMSG);

                            }
                            else
                            {
                                totalDay = (Convert.ToDateTime(strLastDate) - Convert.ToDateTime(strFirstDate)).TotalDays;
                                intTotalDay = Convert.ToInt32(totalDay);
                                strCheckDate = strFirstDate; // "2023-10-30";
                                strMSG = "";

                                for (int k = 0; k <= intTotalDay; k++)
                                {
                                    if (!dateHolidayKeep.Contains(strCheckDate))
                                    {
                                        if (strMSG == "")
                                        {
                                            strMSG = "\r\n" + strCheckDate + " " + strUserName + " 0/8";
                                        }
                                        else
                                        {
                                            strMSG = strMSG + "\r\n" + strCheckDate + " " + strUserName + " 0/8";
                                        }
                                    }
                                    strCheckDate = Convert.ToDateTime(strCheckDate).Date.AddDays(1).ToString("yyyy-MM-dd");

                                }

                                sendLine(strMSG);
                            }
                        }
                        //----------
                        else
                        {
                            totalDay = (Convert.ToDateTime(strLastDate) - Convert.ToDateTime(strFirstDate)).TotalDays;
                            intTotalDay = Convert.ToInt32(totalDay);
                            strCheckDate = strFirstDate; // "2023-10-30";
                            strMSG = "";

                            for (int k = 0; k <= intTotalDay; k++)
                            {
                                if (!dateHolidayKeep.Contains(strCheckDate))
                                {
                                    if (strMSG == "")
                                    {
                                        strMSG = "\r\n" + strCheckDate + " " + strUserName + " 0/8";
                                    }
                                    else
                                    {
                                        strMSG = strMSG + "\r\n" + strCheckDate + " " + strUserName + " 0/8";
                                    }
                                }
                                strCheckDate = Convert.ToDateTime(strCheckDate).Date.AddDays(1).ToString("yyyy-MM-dd");

                            }

                            sendLine(strMSG);
                        }

                    }

                }
            }

        }

        private void process_duedate(string firstDate, string lastDate)
        {
            strFirstDate = firstDate;
            strLastDate = lastDate;
            List<string> dateHoursKeep = new List<string>();
            List<string> dateKeep = new List<string>();
            List<string> dateHolidayKeep = new List<string>();
            Double totalDay = 0;
            Int32 intTotalDay = 0;
            Int32 intTotalDayissues = 0;
            string strCheckDate = string.Empty;
            string strIDissues = string.Empty;
            string strTotalDayissues = string.Empty;
            clsUtil_MSSQL.GetDataFromHolidayAll(RtnDbCon(), "date_holiday", ref dtHolidaySelect);
            if (dtHolidaySelect != null)
            {
                if (dtHolidaySelect.Rows.Count > 0)
                {
                    dateHolidayKeep.Clear();
                    for (int i = 0; i < dtHolidaySelect.Rows.Count; i++)
                    {
                        dateHolidayKeep.Add(Convert.ToDateTime(dtHolidaySelect.Rows[i][1].ToString()).Date.ToString("yyyy-MM-dd"));
                    }
                }

            }

            //Select User
            clsUtil_MSSQL.GetDataFromTBUserSelectAll(RtnDbCon(), "users", ref dtUserSelectAll);
            if (dtUserSelectAll != null)
            {
                if (dtUserSelectAll.Rows.Count > 0)
                {
                    for (int i = 0; i < dtUserSelectAll.Rows.Count; i++)
                    {
                        strIDAllissues = dtUserSelectAll.Rows[i][0].ToString();
                        strUserNameissues = dtUserSelectAll.Rows[i][1].ToString();
                        if (dtUserSelectAll.Rows[i][2] != null)
                        {
                            strStartDateissues = Convert.ToDateTime(dtUserSelectAll.Rows[i][2].ToString()).ToString("yyyy-MM-dd");
                            strFirstDate = strStartDateissues;
                        }
                        else
                        {
                            strFirstDate = "2023-10-30";
                        }

                        //Select User Issue
                        clsUtil_MSSQL.GetDataFromTBissuesSelect(RtnDbCon(), "[issues]", ref dtIssueSelect, strFirstDate, strLastDate, strIDAllissues);
                        if (dtIssueSelect != null)
                        {
                            if (dtIssueSelect.Rows.Count > 0)
                            {
                                strMSGissues = "";

                                for (int j = 0; j < dtIssueSelect.Rows.Count; j++)
                                {
                                    strIDissues = dtIssueSelect.Rows[j][0].ToString();
                                    strDueDate = Convert.ToDateTime(dtIssueSelect.Rows[j][1].ToString()).Date.ToString("yyyy-MM-dd");
                                    totalDay = (Convert.ToDateTime(strLastDate) - Convert.ToDateTime(strDueDate)).TotalDays;
                                    intTotalDay = Convert.ToInt32(totalDay);
                                    strCheckDate = strDueDate;
                                    intTotalDayissues = intTotalDay;
                                    if (strIDissues.Length == 2)
                                    {
                                        strIDissues = strIDissues + "  ";
                                    }
                                    else if (strIDissues.Length == 1)
                                    {
                                        strIDissues = strIDissues + "    ";
                                    }
                                    for (int k = 0; k <= intTotalDay; k++)
                                    {
                                        if (dateHolidayKeep.Contains(strCheckDate))
                                        {
                                            intTotalDayissues = intTotalDayissues - 1;
                                        }
                                        strCheckDate = Convert.ToDateTime(strCheckDate).Date.AddDays(1).ToString("yyyy-MM-dd");
                                    }
                                    strTotalDayissues = intTotalDayissues.ToString();
                                    if (strTotalDayissues.Length == 2)
                                    {
                                        strTotalDayissues = "  " + strTotalDayissues;
                                    }
                                    else if (strTotalDayissues.Length == 1)
                                    {
                                        strTotalDayissues = "    " + strTotalDayissues;
                                    }
                                    if (intTotalDayissues >= 0)
                                    {
                                        if (strMSGissues == "")
                                        {
                                            strMSGissues = "\r\n" + strUserNameissues;
                                            
                                            strMSGissues = strMSGissues + "\r\n" + "#" + strIDissues + " " + strTotalDayissues + "days late";

                                        }
                                        else
                                        {
                                            strMSGissues = strMSGissues + "\r\n" + "#" + strIDissues + " " + strTotalDayissues + "days late";
                                            
                                        }
                                    }

                                }

                                sendLine(strMSGissues);


                            }

                        }

                    }
                }

            }
        }

        private void sendLine(string MSG)
        {
            line_Notify.LineNotify("A", MSG);
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            process(strBeforeDate, strCurrentDate);
            File.WriteAllText(PartFile_isProcess, "false");
            isProcess = "false";
        }

        private void timer1_Tick(object sender, EventArgs e)
        {


            lblDateTime.Text = DateTime.Now.ToString("MM/dd/yyyy HH:mm:ss");

            strCurrentDate = DateTime.Now.ToString("yyyy-MM-dd");
            strCurrentTime = DateTime.Now.ToString("HH:mm");

            clsUtil_MSSQL.GetDataFromHolidaySelect(RtnDbCon(), "date_holiday", ref dtHolidaySelect, DateTime.Now.Date);
            if (dtHolidaySelect != null)
            {
                if (dtHolidaySelect.Rows.Count > 0)
                {
                    return;
                }
            }

            //strBeforeDate = DateTime.Now.AddDays(-1).ToString("yyyy-MM-dd");
            strBeforeDate = "2023-10-30";

            //for (int i = 0; i < 31; i++)
            //{
            //    clsUtil_MSSQL.GetDataFromHolidaySelect(RtnDbCon(), "date_holiday", ref dtHolidaySelect, Convert.ToDateTime(strBeforeDate).Date);
            //    if (dtHolidaySelect != null)
            //    {
            //        if (dtHolidaySelect.Rows.Count > 0)
            //        {
            //            strBeforeDate = Convert.ToDateTime(strBeforeDate).Date.AddDays(-1).ToString("yyyy-MM-dd");
            //        }
            //        else
            //        {
            //            break;
            //        }
            //    }

            //}


            if (DateTime.Now.Hour < 18)
            {

                if (DateTime.Now.Hour == 17 && DateTime.Now.Minute >= 15)
                {

                }
                else
                {
                    File.WriteAllText(PartFile_isProcess, "true");
                    isProcess = "true";
                }
            }

            if (DateTime.Now.Hour == 17 && DateTime.Now.Minute >= 15 && isProcess == "true")
            {

                if (backgroundWorker1.IsBusy == false)
                {
                    backgroundWorker1.RunWorkerAsync();
                }

            }

            if (DateTime.Now.Hour < 17)
            {

                if (DateTime.Now.Hour == 16 && DateTime.Now.Minute >= 30)
                {

                }
                else
                {
                    File.WriteAllText(PartFile_isProcess_DueDate, "true");
                    isProcess_DueDate = "true";
                }
            }

            if (DateTime.Now.Hour == 16 && DateTime.Now.Minute >= 30 && isProcess_DueDate == "true")
            {

                if (backgroundWorker2.IsBusy == false)
                {
                    backgroundWorker2.RunWorkerAsync();
                }

            }


        }

        private void calendarShow(Int32 intYear, string strStatus)
        {

            // Create a Calendar that displays 1/10/2009
            // through 4/18/2009.
            //Calendar basicCalendar = new Calendar();
            //basicCalendar.DisplayDateStart = new DateTime(2023, 10, 1);
            //basicCalendar.DisplayDateEnd = new DateTime(2023, 10, 31);
            //basicCalendar.DisplayDate = new DateTime(2009, 3, 15);
            //basicCalendar.SelectedDate = new DateTime(2009, 2, 15);


            // root is a Panel that is defined elswhere.
            //root.Children.Add(basicCalendar);

            // Create a Calendar that displays dates through
            // Januarary 31, 2009 and has dates that are not selectable.
            //Calendar calendarWithBlackoutDates = new Calendar();
            //calendarWithBlackoutDates.IsTodayHighlighted = false;
            //calendarWithBlackoutDates.DisplayDate = new DateTime(2009, 1, 1);
            //calendarWithBlackoutDates.DisplayDateEnd = new DateTime(2009, 1, 31);
            //calendarWithBlackoutDates.SelectionMode = CalendarSelectionMode.MultipleRange;


            // Add the dates that are not selectable.
            //calendarWithBlackoutDates.BlackoutDates.Add(
            //    new CalendarDateRange(new DateTime(2009, 1, 2), new DateTime(2009, 1, 4)));
            //calendarWithBlackoutDates.BlackoutDates.Add(
            //    new CalendarDateRange(new DateTime(2009, 1, 9)));
            //calendarWithBlackoutDates.BlackoutDates.Add(
            //    new CalendarDateRange(new DateTime(2009, 1, 16)));
            //calendarWithBlackoutDates.BlackoutDates.Add(
            //    new CalendarDateRange(new DateTime(2009, 1, 23), new DateTime(2009, 1, 25)));
            //calendarWithBlackoutDates.BlackoutDates.Add(
            //    new CalendarDateRange(new DateTime(2009, 1, 30)));

            // Add the selected dates.
            //calendarWithBlackoutDates.SelectedDates.Add(
            //    new DateTime(2009, 1, 5));
            //calendarWithBlackoutDates.SelectedDates.AddRange(
            //    new DateTime(2009, 1, 12), new DateTime(2009, 1, 15));
            //calendarWithBlackoutDates.SelectedDates.Add(
            //    new DateTime(2009, 1, 27));

            // root is a Panel that is defined elswhere.
            //root.Children.Add(calendarWithBlackoutDates);



            // Add dates to the AnnuallyBoldedDates array.
            //this.monthCalendar1.AnnuallyBoldedDates =
            //    new System.DateTime[] { new System.DateTime(2023, 4, 20, 0, 0, 0, 0),
            //                        new System.DateTime(2023, 4, 28, 0, 0, 0, 0),
            //                        new System.DateTime(2023, 5, 5, 0, 0, 0, 0),
            //                        new System.DateTime(2023, 7, 4, 0, 0, 0, 0),
            //                        new System.DateTime(2023, 12, 15, 0, 0, 0, 0),
            //                        new System.DateTime(2023, 12, 18, 0, 0, 0, 0)};

            // Add dates to BoldedDates array.
            //this.monthCalendar1.BoldedDates = new System.DateTime[] { new System.DateTime(2023, 10, 28, 0, 0, 0, 0) };

            clsUtil_MSSQL.GetDataFromHolidaySelectYear(RtnDbCon(), "date_holiday", ref dtHolidaySelectYear, intYear);
            if (dtHolidaySelectYear != null)
            {
                if (dtHolidaySelectYear.Rows.Count > 0)
                {
                    this.monthCalendar1.RemoveAllBoldedDates();

                    for (int i = 0; i < dtHolidaySelectYear.Rows.Count; i++)
                    {
                        this.monthCalendar1.AddBoldedDate(Convert.ToDateTime(dtHolidaySelectYear.Rows[i][1].ToString()));

                    }
                }
            }

            //this.monthCalendar1.AddBoldedDate(Convert.ToDateTime("10/28/2023"));

            // Add dates to MonthlyBoldedDates array.
            //this.monthCalendar1.MonthlyBoldedDates =
            //   new System.DateTime[] {new System.DateTime(2023, 1, 15, 0, 0, 0, 0),
            //                      new System.DateTime(2023, 1, 30, 0, 0, 0, 0)};

            // Configure the calendar to display 3 rows by 4 columns of months.
            this.monthCalendar1.CalendarDimensions = new System.Drawing.Size(4, 3);

            // Set week to begin on Monday.
            //this.monthCalendar1.FirstDayOfWeek = System.Windows.Forms.Day.Monday;

            if (strStatus == "Next")
            {
                // Set the maximum visible date on the calendar to 12/31/2023.
                this.monthCalendar1.MaxDate = new System.DateTime(intYear, 12, 31, 0, 0, 0, 0);

                // Set the minimum visible date on calendar to 1/1/2023.
                this.monthCalendar1.MinDate = new System.DateTime(intYear, 1, 1, 0, 0, 0, 0);
            }
            else if (strStatus == "Black")
            {
                // Set the minimum visible date on calendar to 1/1/2023.
                this.monthCalendar1.MinDate = new System.DateTime(intYear, 1, 1, 0, 0, 0, 0);

                // Set the maximum visible date on the calendar to 12/31/2023.
                this.monthCalendar1.MaxDate = new System.DateTime(intYear, 12, 31, 0, 0, 0, 0);
            }
            else
            {
                // Set the minimum visible date on calendar to 1/1/2023.
                this.monthCalendar1.MinDate = new System.DateTime(2000, 1, 1, 0, 0, 0, 0);

                this.monthCalendar1.MinDate = new System.DateTime(intYear, 1, 1, 0, 0, 0, 0);

                // Set the maximum visible date on the calendar to 12/31/2023.
                this.monthCalendar1.MaxDate = new System.DateTime(intYear, 12, 31, 0, 0, 0, 0);

            }


            // Only allow 21 days to be selected at the same time.
            //this.monthCalendar1.MaxSelectionCount = 21;

            // Set the calendar to move one month at a time when navigating using the arrows.
            this.monthCalendar1.ScrollChange = 12;

            // Do not show the "Today" banner.
            //this.monthCalendar1.ShowToday = false;

            // Do not circle today's date.
            //this.monthCalendar1.ShowTodayCircle = false;

            // Show the week numbers to the left of each week.
            //this.monthCalendar1.ShowWeekNumbers = true;


        }


        private void btnAdd_Click(object sender, EventArgs e)
        {
            clsUtil_MSSQL.GetDataFromHolidaySelect(RtnDbCon(), "date_holiday", ref dtHolidaySelect, dtpHoliday.Value.Date);
            if (dtHolidaySelect != null)
            {
                if (dtHolidaySelect.Rows.Count == 0)
                {
                    clsUtil_MSSQL.insertHoliday(RtnDbCon(), dtpHoliday.Value.Date);

                    calendarShow(dtpHoliday.Value.Year, "");

                    MessageBox.Show(this, "เพิ่มข้อมูล Holiday : " + dtpHoliday.Value.Date.ToString("MM/dd/yyyy") + " เรียบร้อย",
                   "Holiday Information", MessageBoxButtons.OK,
                   MessageBoxIcon.Information,
                   MessageBoxDefaultButton.Button1, 0);
                }
                else
                {
                    MessageBox.Show(this, "มีข้อมูล Holiday : " + dtpHoliday.Value.Date.ToString("MM/dd/yyyy") + " อยู่แล้ว",
                   "Holiday Warning", MessageBoxButtons.OK,
                   MessageBoxIcon.Warning,
                   MessageBoxDefaultButton.Button1, 0);
                }
            }

        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            clsUtil_MSSQL.GetDataFromHolidaySelect(RtnDbCon(), "date_holiday", ref dtHolidaySelect, dtpHoliday.Value.Date);
            if (dtHolidaySelect != null)
            {
                if (dtHolidaySelect.Rows.Count > 0)
                {
                    clsUtil_MSSQL.deleteHoliday(RtnDbCon(), dtpHoliday.Value.Date);

                    calendarShow(dtpHoliday.Value.Year, "");

                    MessageBox.Show(this, "ลบข้อมูล Holiday : " + dtpHoliday.Value.Date.ToString("MM/dd/yyyy") + " เรียบร้อย",
                   "Holiday Information", MessageBoxButtons.OK,
                   MessageBoxIcon.Information,
                   MessageBoxDefaultButton.Button1, 0);
                }
                else
                {
                    MessageBox.Show(this, "ยังไม่มีข้อมูล Holiday : " + dtpHoliday.Value.Date.ToString("MM/dd/yyyy") + "",
                   "Holiday Warning", MessageBoxButtons.OK,
                   MessageBoxIcon.Warning,
                   MessageBoxDefaultButton.Button1, 0);
                }
            }
        }

        private void btnNext_Click(object sender, EventArgs e)
        {
            intYearShow = intYearShow + 1;

            calendarShow(intYearShow, "Next");
        }

        private void btnBlack_Click(object sender, EventArgs e)
        {
            intYearShow = intYearShow - 1;

            calendarShow(intYearShow, "Black");
        }

        private void monthCalendar1_DateChanged(object sender, DateRangeEventArgs e)
        {
            dtpHoliday.Value = monthCalendar1.SelectionRange.Start;
        }

        private void backgroundWorker2_DoWork(object sender, DoWorkEventArgs e)
        {
            process_duedate(strBeforeDate, strCurrentDate);
            File.WriteAllText(PartFile_isProcess_DueDate, "false");
            isProcess_DueDate = "false";
        }
    }
}
